#ifndef __MT_EXCEPTIONS_H__
#define __MT_EXCEPTIONS_H__

#include "IErrors.h"

#define MTEXCEPTION_HEADER(type)	public:	type(char * inDescription)	{ description = inDescription; }

class MTException
{
	public:
						MTException()						{ description.clear(); }
						MTException(char * inDescription)	{ description = inDescription; }
		
		virtual void	DoErrorDialog(void)			{ DoError(description.c_str()); }
		virtual void	DoFatalErrorDialog(void)	{ DoFatalError(description.c_str()); }
	
	protected:
		std::string		description;
};

class MTRangeException : public MTException			{ MTEXCEPTION_HEADER(MTRangeException) };
class MTMemoryException : public MTException		{ MTEXCEPTION_HEADER(MTMemoryException) };
class MTUnsupportedException : public MTException	{ MTEXCEPTION_HEADER(MTUnsupportedException) };

#define MTOSEXCEPTION_HEADER(type)	public: type(OSErr inCode, char * inDescription)	{ code = inCode; description = inDescription; }

class MTOSException : public MTException
{
	public:
						MTOSException()										{ code = 0; description.clear(); }
						MTOSException(OSErr inCode, char * inDescription)	{ code = inCode; description = inDescription; }
		
		virtual void	DoErrorDialog(void)			{ DoOSErr(description.c_str(), code); }
		virtual void	DoFatalErrorDialog(void)	{ DoFatalOSErr(description.c_str(), code); }
	
	protected:
		OSErr			code;
};

class MTOSFileException : public MTOSException		{ MTOSEXCEPTION_HEADER(MTOSFileException) };

#endif /* __MT_EXCEPTIONS_H__ */